﻿var catiSettings = {
    context: $(".v-catiSettings"),
    questionnaireId: $("#QuestionnaireId").val(),
    initialize: function () {
        $(".h-questionsThatCount", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: catiSettings.questionnaireId },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#QuestionsThatCount", catiSettings.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        this.bindEvents();

        a4.initializeInputs(catiSettings.context);
    },
    bindEvents: function () {
        this.context.on("change", "#MonitoringType", function () {
            $(".h-questionsThatCount", catiSettings.context).a4autocomplete("toggle", $(this).val() == "MinDuration");            
            $(".v-questionsSection input", catiSettings.context).prop("readonly", $(this).val() == "MinDuration");            
            $(".v-durationSection input", catiSettings.context).prop("readonly", $(this).val() == "QuestionsThatCount");

            if ($(this).val() == "MinDuration")
                catiSettings.setDefaultValue($("#QuestionsToCompleteInterview", catiSettings.context));
            else
                catiSettings.setDefaultValue($("#MinSessionDuration", catiSettings.context));
        });
    },
    setDefaultValue: function (input) {
        $(input).val($(input).val() || 0);
    }
}

var cawiSettings = {
    context: $(".v-cawiSettings"),
    initialize: function () {
        this.bindEvents();

        a4.initializeInputs(cawiSettings.context);
    },
    bindEvents: function () {
        this.context.on("change", "#LaunchInAnotherWindow", function () {
            var isFalse = $(this).val() == "False";

            $(".v-browserSection input", this.context).prop("readonly", isFalse);
            $(".v-browserSection input:radio", this.context).attr("disabled", isFalse);
        });

        this.context.on("change", "#CookieCheckupEnabled", function () {
            $(".v-cookiesCheckUpSection input", this.context).prop("readonly", $(this).val() == "False");
        });

        this.context.on("change", "#CookieImportationEnabled", function () {
            $(".v-cookiesImportationSection input", this.context).prop("readonly", $(this).val() == "False");
        });

        this.context.on("blur", ".v-defaultAutonumeric", function () {
            $(this).val($(this).val() || 0);
        });
    }
}

var capiSettings = {
    context: $(".v-capiSettings"),
    questionnaireId: $("#QuestionnaireId").val(),
    isCloseStrataRuleChanged: false,
    initialize: function () {
        $(".h-messagingContactsAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetUsersForAutoComplete", "Shared", "Home", { multimomultiModeOnly: true }),
            valueProperty: "ExternalId",
            labelProperty: "UserName",
            altValueField: $("#MessagingContactsIds", capiSettings.context),
            multipleSelection: true,
            hideSelectedItems: true
        });

        $(".h-questionsAutocomplete", this.context).each(function () {
            var row = $(this).closest("tr");
            var valueField = $(".v-variableName", row);

            $(this).a4autocomplete({
                ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
                ajaxParams: { questionnaireId: capiSettings.questionnaireId, includeSystemVariables: true },
                valueProperty: "Name",
                labelProperty: "Alias",
                altValueField: valueField
            });
        });

        this.bindEvents();

        a4.initializeInputs(capiSettings.context);
    },
    bindEvents: function () {
        this.context.on("change", ".h-quotasEnforcementRule", function () {
            capiSettings.isCloseStrataRuleChanged = true;
        });

        this.context.on("click", "#submit1", function () {
            if (capiSettings.isCloseStrataRuleChanged) {
                var optionName = $(".h-quotasEnforcementRule option:selected").html();
                modalDialog.showConfirmDialog(confirmSaveEnforcementRuleResources, function () {
                    var form = $("#capiSettingsForm");
                    a4.appendAntiForgeryToken(form);                                       
                    form.submit();
                }, 250, 500, false, { "optionName": optionName });
            }
            
            return !capiSettings.isCloseStrataRuleChanged;
        });
    }
}

var prontoSettings = {
    context: $(".v-prontoSettings"),
    initialize: function () {
        a4.initializeInputs(prontoSettings.context);
    }
}

$(document).ready(function () {
    if (catiSettings.context.length > 0) {
        catiSettings.initialize();
    }

    if (cawiSettings.context.length > 0) {
        cawiSettings.initialize();
    }

    if (capiSettings.context.length > 0) {
        capiSettings.initialize();
    }

    if (prontoSettings.context.length > 0) {
        prontoSettings.initialize();
    }
});